/*
 * GSysInfo Applet
 *  - A GNOME panel applet to display various system information.
 *  Copyright (C) 1999 Jason D. Hildebrand
 *  - jdhildeb@undergrad.math.uwaterloo.ca
 *  - http://www.undergrad.math.uwaterloo.ca/~jdhildeb/gsysinfo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef _GNOMESYSINFO_H
#define _GNOMESYSINFO_H

/* I dunno what PACKAGE means... */
#define PACKAGE "gnome-core"
#define VERSION "1.0"

#include <applet-widget.h>
#include "sysinfo.h"

#define MAX_SWAP_FILES		    8
#define max_rgb_str_size	    8

typedef struct GSysInfoData {
  GtkWidget *applet;
  GtkFixed *fixed;

  gint breadth, depth;
  gint bar_breadth, bar_depth;
  gint gap_depth;

  gboolean setup, vertical;

  gboolean toggle;
  time_t toggle_t;

  guint timeout;
  gint timeout_t;

  /* Widgets n stuff... */

  // drawing areas
  GtkWidget *loadavg_area;
  GtkWidget *load_area;
  GtkWidget *mem_area;
  GtkWidget *swap_area;

  // frames (for the bevelling)
  GtkWidget *loadavg_frame;
  GtkWidget *load_frame;
  GtkWidget *mem_frame;
  GtkWidget *swap_frame;

  // other stuff
  GdkPixmap *pixmap;
  GdkImage *image;
  GdkGC *gc;

  GtkWidget *about_box;

  GtkTooltips * tooltips;
  char		tooltip[ 255 ];
  gboolean	tooltip_update;

  /*
   *
   * For the  "Properties" window ...
   *
   */
  GnomePropertyBox *prop_win;

  /* General */
  GtkObject *timeout_adj;
  GtkWidget *loadavgtoggle, *loadtoggle, *memtoggle, *swaptoggle;
  GtkWidget *insensitive;

  int loadavg_on;
  int load_on;
  int mem_on;
  int swap_on;

  int numbars;

  GnomeColorPicker *foreground_sel;
  GnomeColorPicker *background_sel;

  struct meminfo memstats[ MAX_SWAP_FILES ];
  struct load curload;
  double loadavg;
  int numswapfiles;
  int swap;

} GSysInfoData;

#define MERLIN_CLOCK_TOGGLE_PERIOD 3

/*
 *
 * Configuration defaults
 *
 */


#define MERLIN_CLOCK_DATEMODE_TIME "time"
#define MERLIN_CLOCK_DATEMODE_DATE "date"

/* Global configuration parameters */
#define MERLIN_CLOCK_DEFAULT_DATEMODE        "time"
#define MERLIN_CLOCK_DEFAULT_BREADTH         "48"
#define MERLIN_CLOCK_DEFAULT_EXTENDED        "false"
#define MERLIN_CLOCK_DEFAULT_FOREGROUND      "#FFFF00"
#define MERLIN_CLOCK_DEFAULT_BACKGROUND      "#52080A"
#define MERLIN_CLOCK_DEFAULT_FONT            "fixed"

/*
 *
 * Prototypes
 *
 */
void about_cb (AppletWidget *widget, gpointer data);
void destroy_about(GtkWidget *w, gpointer data);

void gsysinfo_set_size(GSysInfoData *gd);
gint gsysinfo_update(gpointer data);
gint orient_handler(GtkWidget *w, PanelOrientType o,
				   gpointer data);
gint expose_handler(GtkWidget *widget, GdkEventExpose *expose,
				   gpointer data);
GtkWidget *make_new_gsysinfo_applet (const gchar *goad_id);
void gsysinfo_create_gc(GSysInfoData *gd);
void gsysinfo_setup_colors(GSysInfoData *gd);
void set_timeout (GSysInfoData *gd);
GtkWidget *applet_start_new_applet (const gchar *goad_id,
				     const char **params, int nparams);
void configure_layout( GSysInfoData * gd );

typedef struct Color {
    const char *    name;
    const char *    propname;
    gchar	    stringval[max_rgb_str_size];
    gchar	    tempval[max_rgb_str_size];
    GdkColor	    val;
    GtkWidget *	    widget;	    
    GtkWidget *	    label;
} a_color;

enum Colors {
    LOADAVGBAR0 = 0,
    LOADAVGBAR1,
    LOADAVGBAR2,
    LOADAVGBAR3,
    LOADAVGBAR4,
    LOADAVGBAR5,
    LOADAVGBAR6,
    LOADAVGBAR7,
    LOADAVGBAR8,
    LOADAVGBAR9,
    LOADBAR,
    LOADBAR1,
    LOADBAR2,
    MEMBAR0,
    MEMBAR1,
    SWAPBAR,
    BARGAUGEBG,
    NUM_COLORS 
};

extern a_color AppColors[NUM_COLORS];
extern GSysInfoData * gd;

#endif /* GNOMESYSINFO_H */
