/*
 * GSysInfo Applet
 *  - A GNOME panel applet to display various system information.
 *  Copyright (C) 2000 Jason D. Hildebrand
 *  - jdhildeb@undergrad.math.uwaterloo.ca
 *  - http://www.undergrad.math.uwaterloo.ca/~jdhildeb/gsysinfo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <string.h>
#include <time.h>
#include <gnome.h>
#include <gdk/gdkx.h>

#include <applet-widget.h>

#include "gsysinfo.h"
#include "session.h"

void
gsysinfo_session_load(gchar * cfgpath, GSysInfoData * gd)
{
    gchar * tempstring;
    gchar   propname[ 100 ];
    int		    n;

    /* We specify that we want the properties for this applet ... */
    gnome_config_push_prefix (cfgpath);

    gd->load_on = gnome_config_get_bool_with_default( "gsysinfo/load_on=true", NULL );
    gd->loadavg_on = gnome_config_get_bool_with_default( "gsysinfo/loadavg_on=true", NULL );
    gd->mem_on = gnome_config_get_bool_with_default( "gsysinfo/mem_on=true", NULL );
    gd->swap_on = gnome_config_get_bool_with_default( "gsysinfo/swap_on=true", NULL );

    gd->timeout_t = gnome_config_get_int_with_default( "gsysinfo/delay=1000", NULL );

    for( n = 0; n < NUM_COLORS; n++ ) {
	strcpy( propname, "gsysinfo/" );
	strcat( propname, AppColors[n].propname );
	tempstring = gnome_config_get_string( propname );
	if( tempstring != NULL ) {
	    strncpy( AppColors[n].stringval, tempstring, max_rgb_str_size );
	}
    }

    gnome_config_pop_prefix ();
} /* gsysinfo_session_load */

int
gsysinfo_session_save(GtkWidget * w,
		     const char * privcfgpath,
		     const char * globcfgpath,
		     gpointer data)
{
    GSysInfoData *  gd = data;
    gchar	    propname[ 100 ];
    int		    n;

    gnome_config_push_prefix (privcfgpath);

    gnome_config_set_bool( "gsysinfo/load_on", gd->load_on );
    gnome_config_set_bool( "gsysinfo/loadavg_on", gd->loadavg_on );
    gnome_config_set_bool( "gsysinfo/mem_on", gd->mem_on );
    gnome_config_set_bool( "gsysinfo/swap_on", gd->swap_on );

    gnome_config_set_int( "gsysinfo/delay", gd->timeout_t );

    for( n = 0; n < NUM_COLORS; n++ ) {
	strcpy( propname, "gsysinfo/" );
	strcat( propname, AppColors[n].propname );
	gnome_config_set_string ( propname, AppColors[n].stringval );
    }

    gnome_config_pop_prefix ();

    gnome_config_sync ();
    gnome_config_drop_all ();
  
    return FALSE;
} /* gsysinfo_session_save */

void
gsysinfo_session_defaults(GSysInfoData * gd)
{
  /* Global configurable parameters */
  //gd->datemode =  !strcmp (MERLIN_CLOCK_DEFAULT_DATEMODE, MERLIN_CLOCK_DATEMODE_DATE);
  gd->breadth = atoi (MERLIN_CLOCK_DEFAULT_BREADTH);
  gd->timeout_t = 1000;
  gd->timeout = 0;
  gd->bar_breadth = 44;
  gd->bar_depth = 6;
  gd->gap_depth = 5;
  
  gd->load_on = 1;
  gd->loadavg_on = 1;
  gd->mem_on = 1;
  gd->swap_on = 1;

  gd->insensitive = NULL;

} /* gsysinfo_session_defaults */
